ifndef BUILD_TARGET_OS
        ifeq ($(OS),Windows_NT)
                BUILD_TARGET_OS = Windows
        else
                BUILD_TARGET_OS = $(shell uname -s)
        endif
endif

ifeq ($(BUILD_TARGET_OS),Windows)
        CONFIGURE = ./configure --host=i686-w64-mingw32.static
        RPATH_PREFIX =
        LIB_PREFIX =
        LIB_ARCH = .a
        LIB_EXT = .lib
endif
ifeq ($(BUILD_TARGET_OS),Darwin)
        CONFIGURE ?= ./configure
        RPATH_PREFIX = @executable_path
        LIB_PREFIX = lib
        LIB_ARCH = .a
        LIB_EXT = .dylib
endif
ifeq ($(BUILD_TARGET_OS),Linux)
        CONFIGURE ?= ./configure
        RPATH_PREFIX = \$\$ORIGIN
        LIB_PREFIX = lib
        LIB_ARCH = .a
        LIB_EXT = .so
endif

ifndef LIB_EXT
        $(error Unsupported target OS)
endif

ifndef BUILD_TARGET_ARCH
        ifeq ($(BUILD_TARGET_OS),Windows) # WIN32 - Tanslate at runtime
                BUILD_TARGET_ARCH = x86
        else
                BUILD_TARGET_ARCH = $(shell uname -m)
        endif
endif

ifndef BUILD_TARGET_ARCH
        $(error Unknown processor architecture)
endif

BUILD_PLATFORM = $(BUILD_TARGET_OS)/$(BUILD_TARGET_ARCH)
