#ifndef _usbtenki_provider_h__
#define _usbtenki_provider_h__


#include <stdint.h>


#ifdef __cplusplus
extern "C" {
#endif


#if 0
#include "usbtenki.h"
#else
typedef void *USBTenki_dev_handle;
#endif

#include "source.h"


extern VirtualOptions usbtenki_virtual_options;

extern char usbtenki_provider_verbose;


int usbtenki_provider_init();

void usbtenki_provider_shutdown();

struct USBTenki_list_ctx *usbtenki_provider_get_context(void);

uint8_t usbtenki_provider_get_source_count();

Source *usbtenki_provider_get_source(uint8_t index);

USBTenki_dev_handle usbtenki_provider_get_handle(uint8_t index);

Source *usbtenki_provider_find_source(const char *serial_number);

int usbtenki_provider_is_connected(Source *source);

void usbtenki_provider_detect_reconnections(void);

USBTenki_dev_handle usbtenki_provider_find_handle(const char *serial_number);

void usbtenki_provider_poll();


#ifdef __cplusplus
}
#endif

#endif