#ifndef _calcurve_h__
#define _calcurve_h__

/** calcurve **
 * 
 * Computes coefficients for a 2nd order polynomial curve that is used to
 * calibrate values such that:
 * y = a0 + a1.x + a2.x^2
 * 
 */

#ifdef __cplusplus
#include <cmath>
#define ISNAN std::isnan
#else
#include <math.h>
#define ISNAN isnan
#endif

#include <stdint.h>

#include "calpoint.h"

/**
 * Number of calibration coefficients
 */
#define CALCURVE_COEFFS_COUNT 3


#ifdef __cplusplus
extern "C" {
#endif


typedef double Coeff;


// Compute the 2nd order polynomial coefficients [a0, a1, a2] according to 
// up to 3 calibration points [p0, p1, p2], such that a calibrated output y can be 
// computed from raw input x as: y = a0 + a1.x + a2.x^2
// Array coeffs must be CALCURVE_COEFFS_COUNT length
void calcurve_coeffs(const struct Point *points, Coeff* coeffs);


#ifdef __cplusplus
}
#endif

#endif
