#include <QApplication>

#include "Config.h"
#include "DaemonThreadManager.h"
#include "MainWindow.h"

#include <dracal/common/log.hpp>
#include <dracal/common/version.hpp>

int g_deep_trace = 0;

int main(int argc, char **argv) {
    const std::string executable_name = dracal::common::extract_executable_name(argv[0]);
    const size_t max_log_file_size = 100000000; // 100 MB

    if (!dracal::common::initialize_logging(executable_name, "%^[%Y-%m-%d %H:%M:%S.%e] [%l] %v%$", true,
                                            max_log_file_size, false)) {
        dracal_warn("failed to initialize logging: exiting");
        return 1;
    }

    dracal_info("-------------------------------------------------------------");
    dracal_info("DracalView version information");
    dracal_info("executable name: {}", executable_name);
    dracal_info("project name:    {}", dracal::common::s_project_name);
    dracal_info("project version: {}", dracal::common::s_project_version);
    dracal_info("git branch:      {}", dracal::common::s_git_branch);
    dracal_info("git tag:         {}", dracal::common::s_git_tag);
    dracal_info("git hash:        {}", dracal::common::s_git_hash);
    dracal_info("git describe:    {}", dracal::common::s_git_describe);
    dracal_info("build time:      {}", dracal::common::s_build_time);
    dracal_info("dev mode:        {}", dracal::common::s_dracal_dev);
    dracal_info("version string:  {}", dracal::common::s_version);
    dracal_info("=============================================================");

    dracal::common::enable_debug_logs(loadEnableDebugLogs());
    dracal::common::enable_trace_logs(loadEnableTraceLogs());

    QApplication app(argc, argv);

    QFile file(":dracalview.qss");
    file.open(QFile::ReadOnly);
    QString stylesheet = QLatin1String(file.readAll());
    app.setStyleSheet(stylesheet);

    MainWindow *window = new MainWindow();
    window->show();

    app.exec();

    // Wait for threads to shut down cleanly
    DaemonThreadManager::instance().shutdown();
}
