CONFIG += c++17 release
TEMPLATE = app
TARGET = dracalview
RESOURCES	= dracalview.qrc
DEPENDPATH += .
VPATH += ../library ../library/libtenki/src
INCLUDEPATH += ../library ../library ../library/libtenki/src ./external
DEFINES += ENABLE_ALL_CHIPS DRACAL_FORCE_FMT_HEADER_ONLY
QMAKE_TARGET_BUNDLE_PREFIX=com.dracal

win32 {
	DEFINES += WIN32_LEAN_AND_MEAN
	INCLUDEPATH += $$(LIBUSB_DIR)/include
	LIBS += -L$$(LIBUSB_DIR)/Windows/x86 -lusb-1.0
	LIBS += -lws2_32 -liphlpapi
	RC_FILE = dracalview.rc
}

unix {
 CONFIG += link_pkgconfig
 PKGCONFIG += libusb-1.0
 LIBS += -lstdc++fs
}

macx {
	ICON = dracalview.icns
	# Enable pkg-config (disabled by default for mac)
	QT_CONFIG -= no-pkg-config
	PKG_CONFIG = /usr/local/bin/pkg-config
}


greaterThan(QT_MAJOR_VERSION, 4): QT += widgets printsupport network

QT += script

# Input

HEADERS += \
	calpoint.h calcurve.h chip_conv.h chip.h csv.h datalog.h device.h portable_endian.h list.h pow.h quantity.h \
	queue.h select_helper.h socket.h source.h unit.h usbtenki_cmds.h usbtenki.h \
	usbtenki_provider.h usbtenki_version.h version.h virtual.h \
	buffer.h discovery.h protocol.h stream.h str_helper.h tenkinet.h ntp.h timestamp.h \
	TextViewer.h DashSensor.h TenkiDashboard.h LoggingPanel.h LoggingThread.h \
	DataSourceCheckBox.h About.h Config.h MainWindow.h BigView.h GraphView.h BigLabel.h SourceAliasEdit.h \
	UnitPreferenceCombo.h ConfigComboBox.h ConfigLineEdit.h \
	ConfigCheckBox.h BigViewCheckBox.h GraphViewCheckBox.h ConfigPanel.h SelectableColor.h \
	TenkinetProvider.h TenkinetThread.h TenkinetDiscoveryThread.h \
	TenkinetPanel.h TenkinetProviderBox.h OriginTimestamp.h \
	LogConversionDialog.h LogConversionRunnable.h \
	qcustomplot.h GraphQualityPreference.h GraphLegendPreference.h \
	MinMaxResettable.h ThermocoupleColorPreference.h DashSensorDevice.h \
	UnitsDropDown.h GraphLineStyleDialog.h LineStyleDropDown.h HTMLViewer.h \
	CalibrationEditDialog.h CalibrationEditDialog_DXC120.h CalibrationEditDialog_DXC220.h \
	TDevice.h TChannel.h TDeviceManager.h TDeviceSignal.h TProvider.h \
	TUSBProvider.h USBThread.h \
	SmartScrollArea.h \
	EditButton.h QuantityFormat.h \
	MathProvider.h MathChannel.h \
	MathEditDialog.h DashSensorMath.h \
	DataTable.h \
	WatchdogListener.h \
	DaemonThread.h DaemonThreadManager.h \
	dracal/common/chrono.hpp \
	dracal/common/fmt.hpp \
	dracal/common/fs.hpp \
	dracal/common/log.hpp \
	dracal/common/platform.hpp \
	dracal/common/string.hpp \
	dracal/common/_version.hpp \
	dracal/common/version.hpp \
	dracal/logging/interval_logger.hpp \
	dracal/logging/utils.hpp \


SOURCES +=  main.cpp \
	calpoint.c calcurve.c chip.c chip_conv.c csv.c datalog.c device.c list.c pow.c quantity.c \
	source.c unit.c usbtenki.c usbtenki_provider.c version.c virtual.c \
	queue.c select_helper.c buffer.c discovery.c socket.c stream.c tenkinet.c ntp.c timestamp.c \
	TextViewer.cpp DashSensor.cpp TenkiDashboard.cpp LoggingPanel.cpp LoggingThread.cpp \
	DataSourceCheckBox.cpp About.cpp Config.cpp MainWindow.cpp BigView.cpp GraphView.cpp \
	UnitPreferenceCombo.cpp ConfigComboBox.cpp ConfigLineEdit.cpp \
	ConfigCheckBox.cpp BigViewCheckBox.cpp GraphViewCheckBox.cpp \
	TenkinetProvider.cpp TenkinetThread.cpp TenkinetDiscoveryThread.cpp \
	TenkinetPanel.cpp TenkinetProviderBox.cpp OriginTimestamp.cpp \
	LogConversionDialog.cpp LogConversionRunnable.cpp \
	SourceAliasEdit.cpp BigLabel.cpp ConfigPanel.cpp SelectableColor.cpp \
	qcustomplot.cpp GraphQualityPreference.cpp GraphLegendPreference.cpp \
	MinMaxResettable.cpp ThermocoupleColorPreference.cpp \
	DashSensorDevice.cpp EditButton.cpp UnitsDropDown.cpp GraphLineStyleDialog.cpp LineStyleDropDown.cpp HTMLViewer.cpp \
	CalibrationEditDialog.cpp CalibrationEditDialog_DXC120.cpp CalibrationEditDialog_DXC220.cpp \
	TDevice.cpp TChannel.cpp TDeviceManager.cpp TDeviceSignal.cpp TProvider.cpp \
	TUSBProvider.cpp USBThread.cpp \
	SmartScrollArea.cpp \
	QuantityFormat.cpp \
	MathProvider.cpp MathChannel.cpp \
	MathEditDialog.cpp DashSensorMath.cpp \
	DataTable.cpp \
	DaemonThread.cpp DaemonThreadManager.cpp \
	dracal/common/chrono.cpp \
	dracal/common/fs.cpp \
	dracal/common/log.cpp \
	dracal/common/string.cpp \
	dracal/logging/interval_logger.cpp \
	dracal/logging/utils.cpp \
