/* -*- mode: c++ -*-
 * Copyright 2025 Dracal Technologies Inc. All rights reserved.
 */

#pragma once

#if (defined(_WIN32) || defined(_WIN64))
    #ifndef DRACAL_WINDOWS
        #define DRACAL_WINDOWS
    #endif
#elif defined(__APPLE__)
    #ifndef DRACAL_APPLE
        #define DRACAL_APPLE
    #endif
#elif defined(__linux__)
    #ifndef DRACAL_LINUX
        #define DRACAL_LINUX
    #endif
#endif

// cppcheck-suppress preprocessorErrorDirective
#if __cplusplus >= 202002L && __has_include(<span>)
    #define DRACAL_HAS_SPAN
#endif

// cppcheck-suppress preprocessorErrorDirective
#if __cplusplus >= 202002L && __has_include(<source_location>)
    #define DRACAL_HAS_SOURCE_LOCATION
#endif

// cppcheck-suppress preprocessorErrorDirective
#if __cplusplus >= 201703L && __has_include(<filesystem>)
    #define DRACAL_HAS_FILESYSTEM
#elif __has_include(<experimental/filesystem>)
    #define DRACAL_HAS_EXPERIMENTAL_FILESYSTEM
#endif
