/* -*- mode: c++ -*-
 * Copyright 2025 Dracal Technologies Inc. All rights reserved.
 */

#pragma once

#include <string>
#include <cstdint>

namespace dracal::common {

static const std::string s_project_name = "dracal-utilities";
static const std::string s_project_version = "3.4.5.0";
static const std::string s_git_branch = "main";
static const std::string s_git_tag = "v3.4.5-r1";
static const std::string s_git_hash = "88dfd4e1";
static const std::string s_git_describe = "v3.4.5-r1";
static const std::string s_build_time = "2025-10-23T14:51:03Z";

static constexpr uint32_t s_version_major = 3;
static constexpr uint32_t s_version_minor = 4;
static constexpr uint32_t s_version_patch = 5;
static constexpr uint32_t s_version_tweak = 0;

static constexpr bool s_dracal_dev = false;

static const std::string s_version =
    s_dracal_dev ? s_project_version + "|" + s_git_branch + "|" + s_git_hash : s_project_version + "|" + s_git_tag;

} // namespace dracal::common
