#include "UnitsDropDown.h"
#include <QDebug>

UnitsDropDown::UnitsDropDown() {
    addChoice(tr("Arbitrary unit"), UNIT_ARBITRARY);

    addChoice(tr("Temperature: Celsius"), UNIT_CELSIUS);
    addChoice(tr("Temperature: Fahrenheit"), UNIT_FAHRENHEIT);
    addChoice(tr("Temperature: Kelvin"), UNIT_KELVIN);

    addChoice(tr("Relative Humidity: %"), UNIT_RH);

    addChoice(tr("Pressure: kPa"), UNIT_KPA);
    addChoice(tr("Pressure: hPa"), UNIT_HPA);
    addChoice(tr("Pressure: Pa"), UNIT_PA);
    addChoice(tr("Pressure: Bar"), UNIT_BAR);
    addChoice(tr("Pressure: At"), UNIT_AT);
    addChoice(tr("Pressure: Atm"), UNIT_ATM);
    addChoice(tr("Pressure: Torr"), UNIT_TORR);
    addChoice(tr("Pressure: PSI"), UNIT_PSI);
    addChoice(tr("Pressure: inHg"), UNIT_INHG);

    addChoice(tr("Concentration: % "), UNIT_PERCENT);
    addChoice(tr("Concentration: ppm"), UNIT_PPM);
    addChoice(tr("Concentration: ppb"), UNIT_PPB);

    addChoice(tr("Tension: V"), UNIT_VOLT);
    addChoice(tr("Tension: mV"), UNIT_MILLIVOLT);

    addChoice(tr("Current: A"), UNIT_AMP);
    addChoice(tr("Current: mA"), UNIT_MILLIAMP);

    addChoice(tr("Power: kW"), UNIT_KILOWATT);
    addChoice(tr("Power: W"), UNIT_WATT);
    addChoice(tr("Power: mW"), UNIT_MILLIWATT);

    addChoice(tr("Frequency: mHz"), UNIT_MILLIHZ);
    addChoice(tr("Frequency: Hz"), UNIT_HZ);
    addChoice(tr("Frequency: kHz"), UNIT_KHZ);
    addChoice(tr("Frequency: MHz"), UNIT_MHZ);
    addChoice(tr("Frequency: RPM"), UNIT_RPM);

    addChoice(tr("Distance: m"), UNIT_METER);
    addChoice(tr("Distance: dm"), UNIT_DECIMETER);
    addChoice(tr("Distance: cm"), UNIT_CENTIMETER);
    addChoice(tr("Distance: mm"), UNIT_MILLIMETER);
    addChoice(tr("Distance: um"), UNIT_MICROMETER);
    addChoice(tr("Distance: mil"), UNIT_MIL);
    addChoice(tr("Distance: inch"), UNIT_INCH);
    addChoice(tr("Distance: ft"), UNIT_FEET);
    addChoice(tr("Distance: yard"), UNIT_YARD);

    // addChoice(tr(""), );
}

UnitsDropDown::~UnitsDropDown() {
    int i;
    for (i = 0; i < choices.size(); i++) {
        delete choices.at(i);
    }
    choices.clear();
}

void UnitsDropDown::selectUnits(int units) {
    int i;

    for (i = 0; i < choices.size(); i++) {
        if (choices.at(i)->value == units) {
            setCurrentIndex(i);
            return;
        }
    }
}

int UnitsDropDown::getSelectedUnits() {
    int i;

    i = currentIndex();

    if (i < choices.size()) {
        return choices.at(i)->value;
    }

    return UNIT_RAW;
}

void UnitsDropDown::addChoice(QString caption, int value) {
    struct unitChoice *choice = new unitChoice;

    choice->caption = caption;
    choice->value = value;
    choices.append(choice);

    addItem(caption);
}
