#include <QSettings>

#include "QuantityFormat.h"
#include "UnitPreferenceCombo.h"

UnitPreferenceCombo::UnitPreferenceCombo(CSV_Options *csvopt, unit_category_t cat, const QString &configKey,
                                         const QVector<UnitDescription> &unitDescriptions, int defaultIndex)
    : csvopt(csvopt), unitCategory(cat), configKey(configKey), unitDescriptions(&unitDescriptions) {

    for (int i = 0; i < unitDescriptions.size(); i++) {
        addItem(unitDescriptions[i].text);
    }

    QSettings settings;
    int selected = settings.value(configKey, defaultIndex).toInt();
    setCurrentIndex(selected);
    unitSelected(selected);

    connect(this, SIGNAL(currentIndexChanged(int)), this, SLOT(unitSelected(int)));
}

int UnitPreferenceCombo::getSelectedUnit() { return csvopt->units[unitCategory]; }

void UnitPreferenceCombo::unitSelected(int index) {

    QSettings settings;
    settings.setValue(configKey, index);

    unit_t unit = unitDescriptions->at(index).unit;
    csvopt->units[unitCategory] = unit;
}

static const QVector<UnitDescription> CONCENTRATION = {
    {UNIT_SENSOR_DEFAULT, "Sensor default"},
    {UNIT_PPB, "ppb"},
    {UNIT_PPM, "ppm"},
    {UNIT_PERCENT, "%"},
};

static const QVector<UnitDescription> CURRENT = {
    {UNIT_AMP, "Ampere (A)"},
    {UNIT_MILLIAMP, "Milliampere (mA)"},
};

static const QVector<UnitDescription> FREQUENCY = {
    {UNIT_MILLIHZ, "mHz"}, {UNIT_HZ, "Hz"}, {UNIT_KHZ, "kHz"}, {UNIT_MHZ, "MHz"}, {UNIT_RPM, "rpm"},
};

static const QVector<UnitDescription> LENGTH = {
    {UNIT_MILLIMETER, "millimeters"},
    {UNIT_CENTIMETER, "centimeters"},
    {UNIT_DECIMETER, "decimeters"},
    {UNIT_METER, "meters"},
    {UNIT_MIL, "mils (1/1000in)"},
    {UNIT_INCH, "inches"},
    {UNIT_FEET, "feet"},
    {UNIT_YARD, "yards"},
};

static const QVector<UnitDescription> POWER = {
    {UNIT_WATT, "Watt (W)"},
    {UNIT_MILLIWATT, "Milliwatt (mW)"},
};

static const QVector<UnitDescription> PRESSURE = {
    {UNIT_KPA, "kPa"},
    {UNIT_HPA, "hPa"},
    {UNIT_PA, "Pa"},
    {UNIT_BAR, "bar"},
    {UNIT_AT, "at (98.0665 kPa)"},
    {UNIT_ATM, "atm (101.325 kPa)"},
    {UNIT_TORR, "Torr"},
    {UNIT_PSI, "psi"},
    {UNIT_INHG, "inHg"},
};

static const QVector<UnitDescription> TEMPERATURE = {
    {UNIT_CELSIUS, "Celsius"},
    {UNIT_FAHRENHEIT, "Fahrenheit"},
    {UNIT_KELVIN, "Kelvin"},
};

static const QVector<UnitDescription> VOLTAGE = {
    {UNIT_VOLT, "Volt (V)"},
    {UNIT_MILLIVOLT, "Millivolt (mV)"},
};

ConcentrationPreferenceCombo::ConcentrationPreferenceCombo(CSV_Options *csvopt)
    : UnitPreferenceCombo(csvopt, UNIT_CATEGORY_CONCENTRATION, ("data/concentration_unit"), CONCENTRATION) {}

CurrentPreferenceCombo::CurrentPreferenceCombo(CSV_Options *csvopt)
    : UnitPreferenceCombo(csvopt, UNIT_CATEGORY_CURRENT, QString("data/current_unit"), CURRENT) {}

FrequencyPreferenceCombo::FrequencyPreferenceCombo(CSV_Options *csvopt)
    : UnitPreferenceCombo(csvopt, UNIT_CATEGORY_FREQUENCY, QString("data/frequency_unit"), FREQUENCY) {}

LengthPreferenceCombo::LengthPreferenceCombo(CSV_Options *csvopt)
    : UnitPreferenceCombo(csvopt, UNIT_CATEGORY_LENGTH, QString("data/length_unit"), LENGTH, 3) {}

PowerPreferenceCombo::PowerPreferenceCombo(CSV_Options *csvopt)
    : UnitPreferenceCombo(csvopt, UNIT_CATEGORY_POWER, QString("data/power_unit"), POWER) {}

PressurePreferenceCombo::PressurePreferenceCombo(CSV_Options *csvopt)
    : UnitPreferenceCombo(csvopt, UNIT_CATEGORY_PRESSURE, QString("data/pressure_unit"), PRESSURE) {}

TemperaturePreferenceCombo::TemperaturePreferenceCombo(CSV_Options *csvopt)
    : UnitPreferenceCombo(csvopt, UNIT_CATEGORY_TEMPERATURE, QString("data/temperature_unit"), TEMPERATURE) {}

VoltagePreferenceCombo::VoltagePreferenceCombo(CSV_Options *csvopt)
    : UnitPreferenceCombo(csvopt, UNIT_CATEGORY_VOLTAGE, QString("data/voltage_unit"), VOLTAGE) {}
