#include "ThermocoupleColorPreference.h"
#include "unit.h"
#include <QSettings>

ThermocoupleColorPreference::ThermocoupleColorPreference() {
    QSettings settings;

    config_key = "data/thermocouple_color_system";

    addItem(tr("ANSI"));
    addItem(tr("IEC"));

    setCurrentIndex(settings.value(config_key).toInt());

    connect(this, SIGNAL(currentIndexChanged(int)), this, SLOT(idx_changed(int)));
}

bool ThermocoupleColorPreference::isIEC(void) { return currentIndex() != 0; }

void ThermocoupleColorPreference::idx_changed(int idx) {
    QSettings settings;

    settings.setValue(config_key, idx);
}
