#ifndef _TextViewer_h__
#define _TextViewer_h__

#include <QDialog>
#include <QDialogButtonBox>
#include <QFile>
#include <QPlainTextEdit>
#include <QPushButton>
#include <QTimer>
#include <QVBoxLayout>

class TextViewer : public QDialog {
    Q_OBJECT

  public:
    TextViewer(const QString &filename, const QString &title);
    virtual ~TextViewer();

  public slots:
    void followFile();
    void reloadFile();

  private:
    QPlainTextEdit *editor;
    QVBoxLayout *layout;
    QDialogButtonBox *btnbox;
    QPushButton *closeBtn;
    QTimer *timer;
    QFile *file;
};

#endif // _TextViewer_h__
