#ifndef _TenkinetProviderBox_h__
#define _TenkinetProviderBox_h__

#include <QCheckBox>
#include <QComboBox>
#include <QGroupBox>
#include <QLabel>
#include <QMovie>
#include <QPushButton>
#include <QTimer>

#include "ConfigCheckBox.h"
#include "TenkinetProvider.h"

class TenkinetProviderBox : public QGroupBox {

    Q_OBJECT

  public:
    TenkinetProviderBox(TenkinetProvider *provider, bool locked);
    virtual ~TenkinetProviderBox();

  public slots:

    void setLocked(bool locked);
    void setReconnection(unsigned int seconds);

  private slots:

    void onConnecting(TenkinetProvider *provider);
    void onConnected(TenkinetProvider *provider);
    void onDisconnected(TenkinetProvider *provider);
    void onError(TenkinetProvider *provider);
    void onRefreshing(TenkinetProvider *provider);
    void onRefreshed(TenkinetProvider *provider);
    void onEnabled(TenkinetProvider *provider);
    void onDisabled(TenkinetProvider *provider);

    void onClickIcon();
    void onClickWeb();
    void onClickRemove();

    void enableWebButton();

    void refreshHeader();
    void refreshDevices();
    void refreshLoadingMovie();

    void resetCombo(int index);
    void setEnabled(int state);

  private:
    TenkinetProvider *provider;
    bool locked;

    QPushButton *iconButton;
    QLabel *addressLabel;
    QComboBox *devicesCombo;
    QCheckBox *enableCheck;
    QPushButton *webButton;
    QPushButton *removeButton;

    QMovie *loadingMovie;
    QTimer *webTimer;

    // TODO these could be static
    QPixmap *configPixmap;
    QPixmap *connectedPixmap;
    QPixmap *errorPixmap;
    QPixmap *deletePixmap;
    QPixmap *deleteDisabledPixmap;
};

#endif
