#include "SourceAliasEdit.h"
#include <QSettings>

#include "TDeviceManager.h"

SourceAliasEdit::SourceAliasEdit(const QString &channelID) : ID(channelID) {
    QSettings settings;

    setText(TDeviceManager::instance().getAlias(channelID));

    connect(this, SIGNAL(editingFinished()), this, SLOT(onEdit()));
    connect(&TDeviceManager::instance(), &TDeviceManager::channelAliasUpdated, this, &SourceAliasEdit::onAliasUpdate);
}

void SourceAliasEdit::onEdit() { emit sourceAliasChanged(ID, text()); }

void SourceAliasEdit::onAliasUpdate(const QString id, const QString alias) {

    if (ID == id && alias != text()) {
        setText(alias);
        emit sourceAliasChanged(ID, alias);
    }
}
