#ifndef _OriginTimestamp_h__
#define _OriginTimestamp_h__

#include <QMutex>
#include <stdint.h>

#include <dracal/common/chrono.hpp>

#include "timestamp.h"

/**
 * Singleton class
 */
class OriginTimestamp {

  public:
    static OriginTimestamp &instance() {
        static OriginTimestamp instance;
        return instance;
    }

    OriginTimestamp(OriginTimestamp const &) = delete;
    void operator=(OriginTimestamp const &) = delete;

    int64_t value();

    chrono::time_point<chrono::steady_clock> steady_value();

  private:
    OriginTimestamp();

    QMutex mutex;
    int64_t origin;
    chrono::time_point<chrono::steady_clock> steady_origin;
    bool ready = false;
};

#endif
