#include <QMutexLocker>

#include "OriginTimestamp.h"
#include "timestamp.h"

OriginTimestamp::OriginTimestamp() {}

int64_t OriginTimestamp::value() {
    QMutexLocker locker(&mutex);

    if (!ready) {
        ready = true;
        origin = timestamp_now();
        steady_origin = chrono::steady_clock::now();
    }

    return origin;
}

chrono::time_point<chrono::steady_clock> OriginTimestamp::steady_value() {
    QMutexLocker locker(&mutex);

    if (!ready) {
        ready = true;
        origin = timestamp_now();
        steady_origin = chrono::steady_clock::now();
    }

    return steady_origin;
}
