#ifndef _MathProvider_h__
#define _MathProvider_h__

#include "MathChannel.h"
#include "TProvider.h"

class MathProvider : public TProvider {

    Q_OBJECT

  public:
    // Singleton instance
    static MathProvider &instance() {
        static MathProvider instance;
        return instance;
    }

    virtual ~MathProvider();

    // Disable copy constructor and assignment operator
    // Required to enforce singleton pattern
    MathProvider(MathProvider const &) = delete;
    void operator=(MathProvider const &) = delete;

    virtual int getDeviceCount();
    virtual QVector<TDevice *> getDevices();
    virtual TDevice *findDevice(const QString &serialNumber);

    virtual int start();
    virtual void shutdown();

    virtual void setPollInterval(int ms);
    virtual void setVirtualOptions(unsigned int flags, double slp);
    virtual void setUserCalibration(const QString &serialNumber, int channelIndex, bool on);

    void setExpression(int index, const QString &expression);
    void setUnit(int index, unit_t unit);

    QString getExpression(int index) const;
    unit_t getUnit(int index) const;

  private:
    MathProvider();

    bool started = false;
    QVector<MathChannel *> mathChannels;
};

#endif
