#ifndef _LogConversionRunnable_h__
#define _LogConversionRunnable_h__

#include <QObject>
#include <QRunnable>
#include <QString>

#include "csv.h"

class LogConversionRunnable : public QObject, public QRunnable {

    Q_OBJECT

    const QString inputPath;
    const QString outputPath;
    CSV_Options csvopt;

  public:
    enum Error {
        SUCCESS = 0,
        ERROR_OPEN_INPUT,
        ERROR_OPEN_OUTPUT,
    };

    LogConversionRunnable(const QString &inputPath, const QString &outputPath);
    virtual ~LogConversionRunnable();

    virtual void run();

  signals:

    void error(int code);
    void progress(unsigned int done, unsigned int total);
};

#endif