#include "GraphViewCheckBox.h"
#include "GraphView.h"

GraphViewCheckBox::GraphViewCheckBox(const QString &channelId)
    : ConfigCheckBox("", "graphChecked/" + channelId), channelId(channelId) {
    connect(this, &ConfigCheckBox::changed, this, &GraphViewCheckBox::onChange);
    onChange(isChecked());
}

void GraphViewCheckBox::onChange(bool checked) {

    if (checked) {
        GraphView::instance().addChannel(channelId);
    } else {
        GraphView::instance().removeChannel(channelId);
    }
}