#include <QSettings>

#include "GraphQualityPreference.h"

static const QString KEY("graph/line_quality");

GraphQualityPreference::GraphQualityPreference() {

    addItem("Low");
    addItem("High");

    QSettings settings;
    setCurrentIndex(settings.value(KEY, 1).toInt());

    connect(this, SIGNAL(currentIndexChanged(int)), this, SLOT(onChange(int)));
}

GraphQualityPreference::Value GraphQualityPreference::getValue() {

    return (GraphQualityPreference::Value)currentIndex();
}

void GraphQualityPreference::onChange(int i) {

    QSettings settings;

    settings.setValue(KEY, i);
    emit changed();
}
