#ifndef _dashsensor_math_h__
#define _dashsensor_math_h__

#include <QGridLayout>
#include <QGroupBox>
#include <QHash>
#include <QLabel>
#include <QLineEdit>
#include <QList>
#include <QMap>
#include <QString>

#include "ConfigCheckBox.h"
#include "DashSensor.h"
#include "MathEditDialog.h"
#include "MinMaxResettable.h"
#include "TDevice.h"

class DashSensorMath : public DashSensor {
    Q_OBJECT

  public:
    DashSensorMath();
    ~DashSensorMath();

    virtual void activate();
    virtual void deactivate();

  private slots:
    void editClicked(int id);
    void expressionEdited();
    void helpClicked(bool);
    void cbAllBigviewChanged(int state);
    void cbAllGraphChanged(int state);
    void refresh(const TDevice *device);

  private:
    void addDevice(TDevice *device, int index, int row);

    QString title;
    QGridLayout *layout;
    QList<QLineEdit *> expressions;
    QList<QLabel *> values;
    QList<QLabel *> units;
    QList<MinMaxResettable *> minimums;
    QList<MinMaxResettable *> maximums;

    MathEditDialog *editDialog;
    QPushButton *helpbtn;
    QCheckBox *cb_all_graph, *cb_all_bigview;

    QList<ConfigCheckBox *> bigviewCheckboxes;
    QList<ConfigCheckBox *> graphCheckboxes;

    QHash<QString, int> indexBySerialNumber;

    void recolorizeThermocouple(void);
    int prev_iec;
};

#endif
