#ifndef _dashsensor_device_h__
#define _dashsensor_device_h__

#include <QGridLayout>
#include <QLabel>
#include <QObject>
#include <QToolButton>
#include <QVector>

#include "ConfigCheckBox.h"
#include "DashSensor.h"
#include "EditButton.h"
#include "MinMaxResettable.h"
#include "SourceAliasEdit.h"
#include "TDevice.h"

class DashSensorDevice : public DashSensor {
    Q_OBJECT

  public:
    DashSensorDevice(const TDevice *device);
    virtual ~DashSensorDevice();

    virtual void activate();
    virtual void deactivate();

  private:
    struct ChannelWidgets {
        QLabel *idLabel;
        QLabel *descriptionLabel;
        QLabel *typeLabel;
        QLabel *valueLabel;
        MinMaxResettable *minResettable;
        MinMaxResettable *maxResettable;
        QToolButton *resetMinMaxButton;
        QLabel *unitLabel;
        SourceAliasEdit *aliasEdit;
        ConfigCheckBox *bigViewCheckBox;
        ConfigCheckBox *graphViewCheckBox;
        QWidget *calibrateWidget;
        QDialog *calibrationEditDialog;
        QLabel *attentionLabel;
    };

    TDevice *device;

    QString baseTitle;
    QGridLayout *layout;
    QVector<ChannelWidgets *> channelWidgets;

    bool calibrateInProgress = false;

    void addChannel(TChannel *channel);
    void refreshAttentionLabels();
    void refresh();

  private slots:

    void onDeviceUpdated(const TDevice *device);

    void onInfoClicked(bool);
    void onBigViewAllChecked(int state);
    void onGraphViewAllChecked(int state);
    void onCalibrateClicked(int id);
    void onThermocoupleColorChanged(bool iec);
};

#endif
