#ifndef _DaemonThreadManager_h__
#define _DaemonThreadManager_h__

#include <QMutex>
#include <QVector>

#include "DaemonThread.h"

class DaemonThreadManager {

    DaemonThreadManager();

    QMutex mutex;
    QVector<DaemonThread *> threads;

  public:
    // Singleton instance
    static DaemonThreadManager &instance() {
        static DaemonThreadManager instance;
        return instance;
    }

    // Disable copy constructor and assignment operator
    // Required to enforce singleton pattern
    DaemonThreadManager(DaemonThreadManager const &) = delete;
    void operator=(DaemonThreadManager const &) = delete;

    void addThread(DaemonThread *t);
    void removeThread(DaemonThread *t);
    void shutdown();
};

#endif
