#include "DaemonThreadManager.h"

DaemonThreadManager::DaemonThreadManager() {}

void DaemonThreadManager::addThread(DaemonThread *t) {

    mutex.lock();
    threads.append(t);
    mutex.unlock();
}

void DaemonThreadManager::removeThread(DaemonThread *t) {

    mutex.lock();
    threads.removeOne(t);
    mutex.unlock();
}

void DaemonThreadManager::shutdown() {

    mutex.lock();

    for (int i = 0; i < threads.size(); i++) {
        threads[i]->shutdown();
    }

    for (int i = 0; i < threads.size(); i++) {
        threads[i]->wait();
    }

    threads.clear();

    mutex.unlock();
}
