#include <QSettings>

#include "ConfigLineEdit.h"

ConfigLineEdit::ConfigLineEdit(const QString &key, const QString &defaultValue) : key(key) {
    QSettings settings;
    setText(settings.value(key, defaultValue).toString());

    connect(this, &QLineEdit::editingFinished, this, &ConfigLineEdit::onChange);
}

ConfigLineEdit::~ConfigLineEdit() {}

void ConfigLineEdit::setTextAndSave(const QString &s) {

    setText(s);

    QSettings settings;
    settings.setValue(key, s);
}

void ConfigLineEdit::onChange() {

    QSettings settings;
    settings.setValue(key, text());
}
