#include "ConfigCheckBox.h"
#include <QSettings>

ConfigCheckBox::ConfigCheckBox(QString caption, QString configKey, bool checkedByDefault) : configKey(configKey) {
    QSettings settings;

    this->configKey = configKey;

    setText(caption);
    setChecked(settings.value(configKey, checkedByDefault).toBool());

    connect(this, SIGNAL(stateChanged(int)), this, SLOT(updateSettings(int)));
}

void ConfigCheckBox::updateSettings(int state) {
    QSettings settings;
    bool checked = state == Qt::CheckState::Checked;
    settings.setValue(configKey, checked);

    emit changed(checked);
}
