#ifndef _Config_h__
#define _Config_h__

#include <QString>
#include <QtGlobal>

bool createDefaultConfigIfMissing();
QString loadTenkiNetPort();
QString loadDracalUsbServicePort();
bool loadEnableDebugLogs();
bool loadEnableTraceLogs();
bool loadEnablePreventSleepDuringLogging();

#ifdef Q_OS_MAC
class MacSleepInhibitor {
  public:
    MacSleepInhibitor();
    ~MacSleepInhibitor();

    // Prevent copying
    MacSleepInhibitor(const MacSleepInhibitor &) = delete;
    MacSleepInhibitor &operator=(const MacSleepInhibitor &) = delete;

    /**
     * @brief Prevent system sleep (display can still sleep)
     * @param reason User-visible reason string (appears in pmset -g assertions)
     * @return true if successful, false otherwise
     */
    bool inhibit(const QString &reason);

    /**
     * @brief Re-enable system sleep
     */
    void uninhibit();

    /**
     * @brief Check if sleep is currently inhibited
     * @return true if active, false otherwise
     */
    bool isActive() const;

  private:
    uint32_t m_assertionID{};
};

#endif // Q_OS_MAC

#endif
