#ifndef _calibration_edit_dialog_dxc120_h__
#define _calibration_edit_dialog_dxc120_h__

#include <QCheckBox>
#include <QDialog>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QString>
#include <QTimer>

#include "TDevice.h"

class CalibrationEditDialog_DXC120 : public QDialog {
    Q_OBJECT

  public:
    CalibrationEditDialog_DXC120(QWidget *parent = 0, const QString &serialNumber = "",
                                 const bool localTenkinet = false);
    virtual ~CalibrationEditDialog_DXC120();

  private slots:
    void refresh();
    void autoCalibrationStateChanged(int state);
    void setFreshAir();

  protected:
    virtual void showEvent(QShowEvent *event);

  private:
    const QString serialNumber;
    const bool localTenkinet;
    QLineEdit *freshAirEdit;
    QCheckBox *cb_disable;
    QPushButton *btn_close;
    QPushButton *btn_set_fresh_air;
};

#endif
