#include "BigViewCheckBox.h"
#include "BigView.h"
#include "TDeviceManager.h"

BigViewCheckBox::BigViewCheckBox(const QString &channelID)
    : ConfigCheckBox("", "bigviewChecked/" + channelID), channelID(channelID) {
    connect(this, &ConfigCheckBox::changed, this, &BigViewCheckBox::onChange);
    onChange(isChecked());
}

void BigViewCheckBox::onChange(bool checked) {

    if (checked) {
        BigView::instance().addChannel(channelID);
    } else {
        BigView::instance().removeChannel(channelID);
    }
}