#ifndef _version_h__
#define _version_h__

/** Version **
 * 
 * Simple version number consisting of three integers: major, minor, and revision
 */

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif


/**
 * Simple version number consisting of three integers: major, minor, and revision
 */
typedef struct Version {

    uint8_t major;
    uint8_t minor;
    uint8_t revision;

} Version;

/**
 * Maximum length of a null-terminated version string:
 * 3 digits, a period, 3 digits, a period, 3 digits, a null character.
 */
#define VERSION_STRING_LEN 12

/**
 * Copy a string representation (null-terminated) of the given version.
 * The destination buffer must be at least VERSION_STR_LEN bytes long.
 * The return value is the number of bytes copied, including the null terminator.
 */
uint8_t version_to_string(Version v, char *dst);


#ifdef __cplusplus
}
#endif

#endif
