#ifndef _usbtenki_cmds_h__
#define _usbtenki_cmds_h__

/**
 * Constants pertaining to the USBTenki protocol.
 */

#define USBTENKI_ERROR 0x00

/* Get sensor chip id/type.
 *   request: USBTENKI_GET_CHIP_ID
 *   value: Channel ID
 * Returned data:
 * [0x01] [id byte] [lrc]
 */
#define USBTENKI_GET_CHIP_ID 0x01

/* Get number of channels.
 *   request: USBTENKI_GET_NUM_CHANNELS
 *   value: Channel ID
 * Returned data:
 * [0x02] [num channel byte] [lrc]
 */
#define USBTENKI_GET_NUM_CHANNELS 0x02


/* Get raw data from sensor.
 *     request: USBTENKI_GET_RAW
 *     value: Channel ID
 * 
 * Returned data on error:
 * [-1]
 *
 * Returned data:
 * [0x10] [n bytes] [lrc]
 */
#define USBTENKI_GET_RAW 0x10

/* Get calibration data for channel.
 *     request: USBTENKI_GET_CALIBRATION
 *     value: Channel ID
 * 
 * Returned data on error:
 * [-1]
 *
 * Returned data:
 * [0x10] [n bytes] [lrc]
 */
#define USBTENKI_GET_CALIBRATION 0x11

/* Configure the type of thermocouple connected
 * to a Dracal TMC100.
 *
 *  request: USBTENKI_SET_THERMOCOUPLE_TYPE
 *  value:
 *      Low byte: channel index (0 for now, reserverd for future use)
 *      High byte: One of THERMOCOUPLE_TYPE_x values.
 */
#define USBTENKI_SET_THERMOCOUPLE_TYPE 0x12

/* Gets the type of thermocouple a Dracal TMC100 device
 * is configured for.
 *
 *  request: USBTENKI_GET_THERMOCOUPLE_TYPE
 *
 *  Returned data:
 *  [0x13] [type byte] [lrc]
 */
#define USBTENKI_GET_THERMOCOUPLE_TYPE 0x13


#define USBTENKI_GET_USER_CALIBRATION_POINTS 0x20
#define USBTENKI_SET_USER_CALIBRATION_POINT 0x21
#define USBTENKI_GET_USER_CALIBRATION_COEFFS 0x22
#define USBTENKI_SET_USER_CALIBRATION_COEFFS 0x23
#define USBTENKI_GET_USER_CALIBRATION_CHANNELS	0x24


// SCD30 built-in chip calibration settings
#define USBTENKI_SCD30_SET_FRC       0x30
#define USBTENKI_SCD30_ENABLE_ASC    0x31
#define USBTENKI_SCD30_GET_ASC       0x32

/* Set the serial number characters one by one.
 *   request: USBTENKI_SET_SERIAL
 *   value: Low byte is character index. 
 *           0xff means done, write to eeprom and become live.
 *           High byte is the character itself.
 *
 * Returned data:
 * [0xf0] [lrc]
 */
#define USBTENKI_SET_SERIAL 0xf0

/* Set the chip type that corresponds to an
 * ADC channel (on the MCU).
 *
 *   request: USBTENKI_SET_ADC_CHIP
 *   value: Low byte is adc channel (0-5)
 *          High byte is the chipid. (or Hidden)
 *
 * Returned data:
 * [0xf1] [lrc]
 */
#define USBTENKI_SET_ADC_CHIP 0xf1

/* Select the ADC reference to use.
 *
 *   request: USBTENKI_SET_ADC_CHIP
 *   value: Low byte (0=internal 5v, 1=adc ref)
 *
 * Returned data:
 * [0xf2] [lrc]
 */
#define USBTENKI_SET_ADC_REF 0xf2


/* Set the RTD current source calibration
 *
 *   request: USBTENKI_SET_RTD_CORR
 *   value: percent * 100 (one signed byte)
 *
 * Returned data:
 * [0xf2] [lrc]
 */
#define USBTENKI_SET_RTD_CORR 0xf3

#define USBTENKI_SET_EM1_CALIBRATION 0xf4
#define USBTENKI_SET_EM1_MAX_CURRENT 0xf5
#define USBTENKI_SET_MISC1_CALIBRATION 0xf4

// Sets Zero or point of origin depending on sensor.
#define USBTENKI_ZERO 0xf6


/* Set poll rate for SHT31.
 *   request: USBTENKI_GET_NUM_CHANNELS
 *   value: Rate, where
 *
 * 0: 0.5 sample per second
 * 1: 1 sample per second
 * 2: 2 samples per second
 * 3: 4 samples per second
 * 4: 10 samples per second
 *
 * Returned data:
 * [0xf6] [lrc]
 */
#define USBTENKI_SET_SHT31_RATE 0xf7


#define USBTENKI_SEND_BUF 0xF8
#define USBTENKI_RECV_BUF 0xF9

#define USBTENKI_ZERO_IN_KNOWN_PPM 0xFA

#define USBTENKI_SET_PROTOCOL 0xFB
#define USBTENKI_PROTOCOL_ID_STANDARD 0
#define USBTENKI_PROTOCOL_ID_NMEA 1
#define USBTENKI_PROTOCOL_ID_VCP 2

#define USBTENKI_RESET_FIRMWARE 0xFD

#define USBTENKI_UNLOCK_CALIBRATION 0xFE

/* Command the device to enter bootloader mode.
 *
 *   request: USBTENKI_BOOTLOADER
 *   value: 0xB007
 *
 * No return (MCU enters bootloader and does not answer)
 */
#define USBTENKI_BOOTLOADER 0xFF


#endif
