#ifndef _protocol_h__
#define _protocol_h__

/**
 * Constants pertaining to the Tenkinet protocol.
 */

#define TENKINET_SERVER_PORT 10395
#define TENKINET_MAGIC_NUMBER 0x289b
#define TENKINET_SERIAL_NUMBER_LEN 7
#define TENKINET_SERVER_NAME_LEN 127
#define TENKINET_INTERVAL_MIN 100000

#define TENKINET_PROTOCOL_NONE 0
#define TENKINET_PROTOCOL 1

typedef enum TenkinetError {
    
    TENKINET_SUCCESS = 0,
    TENKINET_ERROR_INTERNAL,
    TENKINET_ERROR_UNSUPPORTED,
    TENKINET_ERROR_DISCONNECTED,
    TENKINET_ERROR_DEVICE_NOT_FOUND,

} TenkinetError;

typedef enum TenkinetRequest {

    REQUEST_HELLO = 0,
    REQUEST_LIST,
    REQUEST_SUBSCRIBE,
    REQUEST_UNSUBSCRIBE,
    REQUEST_DATA,
    REQUEST_POLL,
    REQUEST_ALIGN,
    REQUEST_PING,

} TenkinetRequest;

typedef enum TenkinetMessage {

    MESSAGE_HELLO = 0,
    MESSAGE_LIST,
    MESSAGE_SUBSCRIBE,
    MESSAGE_UNSUBSCRIBE,
    MESSAGE_DATA,
    MESSAGE_DEVICE_CONNECT,
    MESSAGE_DEVICE_DISCONNECT,
    MESSAGE_PONG,

} TenkinetMessage;


#endif