#ifndef _pow_h__
#define _pow_h__

/** pow **
 *
 * Functions to compute powers of a number, when the exponent is an integer.
 * 
 * These are more efficient than pow() in math.h, for relatively small integer exponents.
 */

#ifdef __cplusplus
extern "C" {
#endif


/**
 * More efficient than pow() for relatively small unsigned integer exponents
 */
double powui(double x, unsigned int y);

/**
 * More efficient than pow() for relatively small signed integer exponents
 */
double powi(double x, int y);


#ifdef __cplusplus
}
#endif

#endif
