#include "pow.h"

double powui(double x, unsigned int y) {

    double result = 1.0;

    while (y > 0) {

        if (y & 1) {
            result *= x;
        }

        x *= x;
        y >>= 1;

    }

    return result;

}

double powi(double x, int y) {

    return (y >= 0) ? powui(x, y) : (1.0 / powui(x, -y));

}
