#ifndef _comparison_h__
#define _comparison_h__

/** comparison **
 * 
 * Comparison functions for comparison-based algorithms.
 * 
 * A few basic comparison functions are implemented.
 */

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Comparison function which compares two arguments and returns an integer.
 * 
 * Arguments are expressed as void pointers for maximum generality.
 * 
 * If a is less than b, return value is negative
 * If a is equal to b, return value is zero
 * If a is greater than b, return value is positive
 */
typedef int (*comparison_fn)(void *a, void *b);

/**
 * Compare arguments treated as signed integers rather than pointers.
 */
int compare_signed_integers(void *a, void *b);

/**
 * Compare arguments treated as unsigned integers rather than pointers.
 */
int compare_unsigned_integers(void *a, void *b);

/**
 * Compare arguments treated as strings, similar to strcmp()
 */
int compare_strings(void *a, void *b);

/**
 * Compare arguments treated as strings (case-insensitive) similar to strcasecmp()
 */
int compare_strings_case_insensitive(void *a, void *b);


#ifdef __cplusplus
}
#endif

#endif
