#include <string.h>
#include <sys/types.h>

#include "comparison.h"
#include "unit.h"

#ifdef _WIN32
#include <basetsd.h>
typedef SSIZE_T ssize_t;
#endif

int compare_signed_integers(void *a, void *b) {

    ssize_t x = (ssize_t) a;
    ssize_t y = (ssize_t) b;

    if (x < y) {
        return -1;
    }

    if (x > y) {
        return 1;
    }

    return 0;

}

int compare_unsigned_integers(void *a, void *b) {

    size_t x = (size_t) a;
    size_t y = (size_t) b;

    if (x < y) {
        return -1;
    }

    if (x > y) {
        return 1;
    }

    return 0;

}

int compare_strings(void *a, void *b) {

    char *s = (char*) a;
    char *t = (char*) b;

    return strcmp(s, t);

}

int compare_strings_case_insensitive(void *a, void *b) {

    char *s = (char*) a;
    char *t = (char*) b;

    return strcasecmp(s, t);

}
