#include "string.h"

#include "calpoint.h"
#include "calcurve.h"


uint8_t calpoints_pack(Point *points) {

    Point *next = points;

    for (Point *p = points; p < points + CAL_POINTS_COUNT; p++) {
        if (POINT_IS_VALID(*p)) {
            if (p != next) {
                *next = *p;
                p->x = NAN;
                p->y = NAN;
            }
            next++;
        }
    }

    return next - points;

}


void calpoints_apply(Quantity *qty, Point *points) {

    if (qty->type == QUANTITY_TYPE_ERROR) {
        return;
    }

    // Compute function parameters
    Coeff coeffs[3];
    calcurve_coeffs(points, coeffs);

    // Get input quantity as double
    double x = quantity_value_as_double(qty);

    // Apply function to input quantity
    double result = coeffs[0] + (coeffs[1]*x) + (coeffs[2]*x*x);

    qty->value_float = (float)result;
    qty->type = QUANTITY_TYPE_FLOAT;

}
