#ifndef _UnitPreferenceCombo_h__
#define _UnitPreferenceCombo_h__


#include <QString>
#include <QVector>
#include <QComboBox>

#include "csv.h"


class UnitDescription {
    public:
        UnitDescription() : UnitDescription(UNIT_SENSOR_DEFAULT, QString("Sensor default")) {}
        UnitDescription(int unit, const QString& text) : unit(unit), text(text) {}
        int unit;
        QString text;
};

class UnitPreferenceCombo : public QComboBox {

    Q_OBJECT

    public:

        UnitPreferenceCombo(CSV_Options *csvopt, unit_category_t cat, const QString& configKey,
            const QVector<UnitDescription>& unitDescriptions, int defaultIndex = 0);

        int getSelectedUnit();
    
    private:

        CSV_Options *csvopt;
        unit_category_t unitCategory;
        QString configKey;
        const QVector<UnitDescription> *unitDescriptions;
        
    private slots:

        void unitSelected(int index);

};

class ConcentrationPreferenceCombo : public UnitPreferenceCombo {

    public:
        ConcentrationPreferenceCombo(CSV_Options *csvopt);

};

class CurrentPreferenceCombo : public UnitPreferenceCombo {

    public:
        CurrentPreferenceCombo(CSV_Options *csvopt);

};

class FrequencyPreferenceCombo : public UnitPreferenceCombo {

    public:
        FrequencyPreferenceCombo(CSV_Options *csvopt);
        
};

class LengthPreferenceCombo : public UnitPreferenceCombo {

    public:
        LengthPreferenceCombo(CSV_Options *csvopt);

};

class PowerPreferenceCombo : public UnitPreferenceCombo {

    public:
        PowerPreferenceCombo(CSV_Options *csvopt);

};

class PressurePreferenceCombo : public UnitPreferenceCombo {

    public:
        PressurePreferenceCombo(CSV_Options *csvopt); 

};

class TemperaturePreferenceCombo : public UnitPreferenceCombo {

    public:
        TemperaturePreferenceCombo(CSV_Options *csvopt);

};

class VoltagePreferenceCombo : public UnitPreferenceCombo {

    public:
        VoltagePreferenceCombo(CSV_Options *csvopt);

};


#endif
