#ifndef _USBThread_h__
#define _USBThread_h__

#include <QMutex>
#include <QHash>
#include <stdint.h>

#include "DaemonThread.h"
#include "source.h"


class TUSBProvider;

class USBThread : public DaemonThread {

    friend class TUSBProvider;

    Q_OBJECT

    USBThread();

    public:

		// Singleton instance
        static USBThread& instance() {
            static USBThread instance;
            return instance;
        }

        // Disable copy constructor and assignment operator
        // Required to enforce singleton pattern
        USBThread(USBThread const&) = delete;
        void operator=(USBThread const&) = delete;

        virtual ~USBThread();

        virtual void run();
        virtual void shutdown();

        void setPollInterval(unsigned int ms);
        void setVirtualOptions(unsigned int flags, double slp);
        void setUserCalibration(const QString& serialNumber, int channelIndex, bool on);


    private:

        enum State {
            INIT,
            SHUTDOWN
        };

        QMutex mutex;
        State state = INIT;
        unsigned int requestedInterval;
        unsigned int interval;

        int64_t now;
        uint64_t pollDelay;

        QHash<QString, Source*> sourcesBySerialNumber;

        int64_t nearestTarget(int64_t origin, uint32_t interval);
        void poll(int64_t timestamp);

};


#endif
