#ifndef _TenkinetDiscoveryThread_h__
#define _TenkinetDiscoveryThread_h__

#include <QMutex>
#include <QWaitCondition>

#include "DaemonThread.h"
#include "TenkinetProvider.h"


class TenkinetDiscoveryThread : public DaemonThread {

    Q_OBJECT

    public:

		// Singleton instance
        static TenkinetDiscoveryThread& instance() {
            static TenkinetDiscoveryThread instance;
            return instance;
        }

        // Disable copy constructor and assignment operator
        // Required to enforce singleton pattern
        TenkinetDiscoveryThread(TenkinetDiscoveryThread const&) = delete;
        void operator=(TenkinetDiscoveryThread const&) = delete;

        virtual void run();
        virtual void shutdown();

        void discover();
    
    signals:

        void discoveryInitialized();
        void discoveryError(int error);
        void discoveryStarted();
        void discoveryEnded();

        void discovered(TenkinetProvider *provider);

    private:

        enum State {
            IDLE,
            DISCOVERY,
            SHUTDOWN
        };

        State state = IDLE;
        QMutex mutex;
        QWaitCondition condition;

        TenkinetDiscoveryThread();

        bool processEvents();

};


#endif
