#include <QLabel>
#include <QDebug>
#include <QVBoxLayout>

#include "TenkiDashboard.h"
#include "DashSensorDevice.h"
#include "TDeviceManager.h"
#include "MathProvider.h"
#include "DashSensorMath.h"


TenkiDashboard::TenkiDashboard()
{

	QVBoxLayout *mainLayout = new QVBoxLayout;
	setLayout(mainLayout);

	setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Maximum);

	QWidget *sensorsWidget = new QWidget();
	sensorsLayout = new QVBoxLayout();
	sensorsWidget->setLayout(sensorsLayout);
	sensorsWidget->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Maximum);

	mainLayout->addWidget(sensorsWidget);

	// Math

	if (MathProvider::instance().getDeviceCount() > 0) {

		QWidget *mathWidget = new QWidget();
		QVBoxLayout *mathLayout = new QVBoxLayout();
		mathWidget->setLayout(mathLayout);

		DashSensor *ds = new DashSensorMath();
		mathLayout->addWidget(ds);

		mainLayout->addWidget(mathWidget);

	}

	mainLayout->addStretch();

	TDeviceManager *deviceManager = &(TDeviceManager::instance());
	connect(deviceManager, &TDeviceManager::deviceAdded, this, &TenkiDashboard::addDevice);
	connect(deviceManager, &TDeviceManager::deviceRemoved, this, &TenkiDashboard::removeDevice);
}

TenkiDashboard::~TenkiDashboard()
{
	// Lives forever
}

void TenkiDashboard::addDevice(const TDevice *device)
{
	if (device->isSpecial()) {
		return;
	}

	DashSensor *ds = sensors.value(device->serialNumber);

	if (!ds) {
		ds = new DashSensorDevice(device);
		sensors.insert(device->serialNumber, ds);
	}

	ds->activate();

	sensorsLayout->addWidget(ds);
	ds->setVisible(true);

}

void TenkiDashboard::removeDevice(const TDevice *device) {

	DashSensor *ds = sensors.value(device->serialNumber);

	if (ds) {
		ds->deactivate();
		ds->setVisible(false);
		sensorsLayout->removeWidget(ds);
	}

}
