#ifndef _TProvider_h__
#define _TProvider_h__


#include <QObject>
#include <QString>
#include <QVector>

#include "TDevice.h"
#include "virtual.h"


class TProvider : public QObject {

    Q_OBJECT

    public:

        TProvider(const QString& description);
        virtual ~TProvider();

        const QString& getDescription() const;

        virtual int getDeviceCount() = 0;
        virtual QVector<TDevice*> getDevices() = 0;
        virtual TDevice* findDevice(const QString& serialNumber) = 0;
    
        virtual int start() = 0;
        virtual void shutdown() = 0;

    public slots:

        virtual void setPollInterval(int ms) = 0;
        virtual void setVirtualOptions(unsigned int flags, double slp) = 0;
        virtual void setUserCalibration(const QString& serialNumber, int channelIndex, bool on) = 0;

    protected:

        const QString description;
        int pollInterval;
        VirtualOptions virtualOptions;


};


#endif
