#include "TProvider.h"
#include "ConfigPanel.h"


TProvider::TProvider(const QString& description) :
    description(description)
{

    ConfigPanel& config = ConfigPanel::instance();
    pollInterval = config.getInterval();
    virtualOptions = config.getVirtualOptions();

    connect(&ConfigPanel::instance(), &ConfigPanel::intervalChanged, this, &TProvider::setPollInterval);
    connect(&ConfigPanel::instance(), &ConfigPanel::virtualOptionsChanged, this, &TProvider::setVirtualOptions);

}

TProvider::~TProvider() {

}

const QString& TProvider::getDescription() const {

    return description;

}
