#ifndef _TChannel_h__
#define _TChannel_h__


#include <stdint.h>

#include <QString>

class TDevice;

#include "TDevice.h"
#include "quantity.h"
#include "calpoint.h"


class TChannel {

    public:

        static QString buildID(const QString& serialNumber, int index);

        TChannel(TDevice *device, int index, uint16_t chip_id, const QString& id);
        TChannel(TDevice *device, int index, uint16_t chip_id);
        TChannel(TDevice *device, const TChannel& channel);

        virtual ~TChannel();

        bool isVirtual() const;
        unit_t getNativeUnit() const;
    
        void convertUnits();
        void invalidate();

        TDevice *device;

        const int index;
        const uint16_t chip_id;
        const QString id;
        const QString description;
        const QString shortDescription;

        Quantity quantity;
        Quantity calibratedQuantity;
        uint8_t calpoints_count;
        Point calpoints[CAL_POINTS_COUNT];

};


#endif