#include <QScrollBar>
#include <QDebug>

#include "SmartScrollArea.h"


SmartScrollArea::SmartScrollArea() {

    connect(horizontalScrollBar(), &QScrollBar::sliderReleased, this, &SmartScrollArea::saveHorizontalPosition);
    connect(verticalScrollBar(), &QScrollBar::sliderReleased, this, &SmartScrollArea::saveVerticalPosition);

    saveHorizontalPosition();
    saveVerticalPosition();

}

SmartScrollArea::~SmartScrollArea() {

}

void SmartScrollArea::restoreLastPosition() {

    horizontalScrollBar()->setSliderPosition(hPos);
    verticalScrollBar()->setSliderPosition(vPos);

}

void SmartScrollArea::saveHorizontalPosition() {

    hPos = horizontalScrollBar()->sliderPosition();

}

void SmartScrollArea::saveVerticalPosition() {

    vPos = verticalScrollBar()->sliderPosition();

}
