#ifndef _QuantityFormat_h__
#define _QuantityFormat_h__


#include <QObject>
#include <QString>

#include "quantity.h"
#include "csv.h"


/**
 * Singleton class
 */ 
class QuantityFormat : public QObject {

    Q_OBJECT

    public:

        // Singleton instance
        static QuantityFormat& instance() {
            static QuantityFormat instance;
            return instance;
        }

        // Disable copy constructor and assignment operator
        // Required to enforce singleton pattern
        QuantityFormat(QuantityFormat const&) = delete;
        void operator=(QuantityFormat const&) = delete;

        void toPreferredUnit(Quantity &qty) const;
        QString toString(double value) const;
        QString toString(const Quantity &qty) const;

    private:

        QuantityFormat();

        CSV_Options *csvopt;
        char format[8];
    
    private slots:

        void setFractionalDigits(int n);

};


#endif