#ifndef _OriginTimestamp_h__
#define _OriginTimestamp_h__

#include <stdint.h>
#include <QMutex>

#include "timestamp.h"


/**
 * Singleton class
 */ 
class OriginTimestamp {

    public:

        // Singleton instance
        static OriginTimestamp& instance() {
            static OriginTimestamp instance;
            return instance;
        }

        // Disable copy constructor and assignment operator
        // Required to enforce singleton pattern
        OriginTimestamp(OriginTimestamp const&) = delete;
        void operator=(OriginTimestamp const&) = delete;

        int64_t value();
    
    private:

        OriginTimestamp();

        QMutex mutex;
        int64_t origin;
        bool ready = false;

};

#endif
