#include <QDebug>

#include "MinMaxResettable.h"
#include "QuantityFormat.h"


MinMaxResettable::MinMaxResettable(bool mode)
{
	minimum_mode = mode;
	empty = true;
}

MinMaxResettable::~MinMaxResettable()
{
}

void MinMaxResettable::reset(void)
{
	empty = true;
	setText("");
}

void MinMaxResettable::submitValue(double value)
{
	QString d;

	// Ignore NaN values
	if (value != value)
		return;

	if (empty) {
		cur_min = cur_max = value;
		empty = false;
		d = QuantityFormat::instance().toString(value);
		setText(d);

	} else {
		if (minimum_mode) {
			if (value < cur_min) {
				cur_min = value;
				d = QuantityFormat::instance().toString(cur_min);
				setText(d);
			}
		} else {
			if (value > cur_max) {
				cur_max = value;
				d = QuantityFormat::instance().toString(cur_max);
				setText(d);
			}
		}
	}
}

