#ifndef _MainWindow_h__
#define _MainWindow_h__

#include <QWidget>
#include <QCloseEvent>
#include <QSystemTrayIcon>
#include <QTabWidget>
#include <QIcon>

#include "TUSBProvider.h"
#include "TenkinetProvider.h"
#include "ConfigPanel.h"
#include "SmartScrollArea.h"


class MainWindow : public QWidget
{
	Q_OBJECT

	QSystemTrayIcon *trayicon;
	QTabWidget *tw;
	QIcon *windowIcon;
	QIcon *trayQIcon;

	SmartScrollArea *dashboardScrollArea;
	SmartScrollArea *loggingScrollArea;
	SmartScrollArea *networkScrollArea;
	SmartScrollArea *configScrollArea;

	int networkTabIndex;

	public:

        MainWindow();
		virtual ~MainWindow();

	protected:
		virtual void readSettings();
		virtual void closeEvent(QCloseEvent *ev);
		virtual void changeEvent(QEvent *e);

	private slots:
		void on_show_hide(QSystemTrayIcon::ActivationReason reason);
		void on_show_hide();
		void showNetworkTab(bool visible);
		void onTabChanged(int index);

};

#endif // _MainWindow_h__
