#ifndef _LoggingThread_h__
#define _LoggingThread_h__

#include <QMutex>
#include <QWaitCondition>
#include <QMap>
#include <QVector>
#include <QLinkedList>

#include "DaemonThread.h"
#include "TDevice.h"
#include "TChannel.h"
#include "TDeviceSignal.h"
#include "DataTable.h"
#include "datalog.h"
#include "csv.h"
#include "queue.h"


class LoggingThread : public DaemonThread {

    Q_OBJECT

    public:

        enum Error {
            ERROR_OPEN_OUTPUT
        };

        LoggingThread(
            const QVector<QString>& channelIDs,
            const QString& path,
            const QString& comment,
            int interval,
            bool append = false
        );
        virtual ~LoggingThread();

        virtual void run();
        virtual void shutdown();

    signals:

        void error(int code);
        void written(qulonglong n);

    private:

        enum State {
            READY,
            SHUTDOWN
        };

        QMutex mutex;
        QWaitCondition condition;

        // Members that are read-only after construction (no need to lock mutex)
        const QString path;
        const int channelCount;
        const char *fileMode;
        const int64_t origin;
        const int64_t interval_us;
        QMap<QString, TDeviceSignal*> deviceSignalBySerial;
        List channelHeaders;

        // Members accessed by local thread only (no need to lock mutex)
        DataTable *table;
        DataLog datalog;
        CSV_Options csvopt;
        CSV csv;
        qulonglong lineCounter;

        // Members accessed by application thread and local thread (MUST LOCK MUTEX)
        State state = READY;
        Queue events;

        // Private methods
        bool processEvents();
        void writeRows();

    private slots:

        // All slots invoked by main application thread (MUST LOCK MUTEX)

        void onDeviceConnected(const TDevice *device);
        void onDeviceDisconnected(const TDevice *device);
        void onDeviceUpdated(const TDevice *device);

        void addEvent(const TDevice* device);

};

#endif
