#ifndef _log_conversion_dialog_h__
#define _log_conversion_dialog_h__


#include <QDialog>
#include <QLineEdit>
#include <QPushButton>
#include <QLabel>
#include <QProgressBar>


class LogConversionDialog : public QDialog {

    Q_OBJECT

    public:

        LogConversionDialog(QWidget *parent = 0);
        virtual ~LogConversionDialog();

    protected:

        virtual void showEvent(QShowEvent *event);
        virtual void reject();

    private slots:

        void browseInputFile();
        void browseOutputFile();
        void convert();
        void onProgress(uint32_t done, uint32_t total);
        void onError(int code);

    private:

        void setLocked(bool locked);

        QLineEdit *inputEdit;
        QLineEdit *outputEdit;
        QPushButton *inputBrowseButton;
        QPushButton *outputBrowseButton;
        QPushButton *convertButton;
        QLabel *errorLabel;

        QProgressBar *progressBar;

};


#endif
